/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.CalcTextBox;
import Calc4M.DashBoard;
import Calc4M.Key;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.media.Manager;
import javax.microedition.rms.RecordStore;
import ral.Real;

public class Settings
extends Canvas
implements CommandListener {
    public static final byte FSE_NONE = 1;
    public static final byte FSE_SCI = 2;
    public static final byte FSE_ENG = 3;
    public static final byte FSE_FIX = 4;
    public static final byte DRG_DEG = 1;
    public static final byte DRG_RAD = 2;
    public static final byte DRG_GRA = 3;
    public static final byte SAFE_STRINGS_SAFE = 0;
    public static final byte SAFE_STRINGS_NICE = 1;
    public static final byte SAFE_STRINGS_NOKIA = 2;
    private static final String STORE_NAME = "Calc4M.1";
    private static final String STORE_MEMORY_POSTFIX = "_mem";
    private static final int MEMORY_MAX_NUMBER = 4;
    private static final int STORE_DRG = 1;
    private static final int STORE_AUTO_ARITHMETIC = 2;
    private static final int STORE_CALC_FONT_SIZE = 3;
    private static final int STORE_REPEAT_VIBRATE = 4;
    private static final int STORE_REPEAT_SOUND = 5;
    private static final int STORE_REPEAT_FLASH = 6;
    private static final int STORE_DISPLAY_STACK = 7;
    private static final int STORE_DISPLAY_WELCOME = 8;
    private static final int STORE_NFSE = 9;
    private static final int STORE_FULLSCREEN = 10;
    private static final int STORE_SAFESTRINGS = 11;
    private static final int STORE_ALTERNATIVE_LAYOUT = 12;
    private static boolean autoReturnToArithmetic = false;
    private static boolean displayStack = true;
    private static boolean displayWelcome = false;
    private static byte DRG = 1;
    private static byte NFSE;
    private static byte localNFSE;
    private static byte fontSize;
    private static int repeatVibrate;
    private static int repeatSound;
    private static int repeatFlash;
    private static boolean fullscreen;
    private static byte safeStrings;
    private static boolean useAlternativeLayout;
    private static Real[] m;
    private static Command commandOk;
    private static Command commandCancel;
    private static DashBoard dashBoard;
    private static Display display;
    private static Gauge inpFontSizeGauge;
    private static ChoiceGroup inpSettings;
    private static ChoiceGroup inpSafeStrings;
    private static ChoiceGroup inpNumberFormat;
    private static ChoiceGroup inpRepeatMark;
    private static TextField decimalCount;
    private static boolean isFirstWelcome;
    private static boolean hasRepeatEvent;

    public Settings() {
        byte[] ptr;
        int i;
        int vendor = Key.getVendor();
        m = new Real[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            Settings.m[i2] = new Real();
        }
        byte[] buf = new byte[12];
        try {
            RecordStore rs = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            if (rs.getNumRecords() != 12) {
                rs.closeRecordStore();
                RecordStore.deleteRecordStore((String)STORE_NAME);
                rs = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                isFirstWelcome = true;
                int width = this.getWidth();
                int height = this.getHeight();
                buf[0] = DRG;
                rs.addRecord(buf, 0, 1);
                buf[0] = (byte)(autoReturnToArithmetic ? 1 : 0);
                rs.addRecord(buf, 0, 1);
                for (i = 6; i > 0; i = (int)((byte)(i - 1))) {
                    fontSize = (byte)i;
                    Font font = Settings.getFont(32);
                    if (font.charWidth('8') <= width / 20) break;
                }
                buf[0] = fontSize;
                rs.addRecord(buf, 0, 1);
                if (vendor == 4) {
                    repeatVibrate = 0;
                }
                ptr = Settings.intToBytes(repeatVibrate);
                rs.addRecord(ptr, 0, ptr.length);
                if (vendor == 4) {
                    repeatSound = 100;
                }
                ptr = Settings.intToBytes(repeatSound);
                rs.addRecord(ptr, 0, ptr.length);
                ptr = Settings.intToBytes(repeatFlash);
                rs.addRecord(ptr, 0, ptr.length);
                buf[0] = (byte)(displayStack ? 1 : 0);
                rs.addRecord(buf, 0, 1);
                buf[0] = (byte)(displayWelcome ? 1 : 0);
                rs.addRecord(buf, 0, 1);
                buf[0] = NFSE;
                rs.addRecord(buf, 0, 1);
                fullscreen = vendor == 8 || width < 250 || height < 250;
                buf[0] = (byte)(fullscreen ? 1 : 0);
                rs.addRecord(buf, 0, 1);
                if (vendor == 4 || vendor == 8) {
                    safeStrings = 0;
                } else if (vendor == 3) {
                    safeStrings = (byte)2;
                }
                buf[0] = safeStrings;
                rs.addRecord(buf, 0, 1);
                buf[0] = (byte)(useAlternativeLayout ? 1 : 0);
                rs.addRecord(buf, 0, 1);
            }
            ptr = rs.getRecord(1);
            DRG = ptr[0];
            ptr = rs.getRecord(2);
            autoReturnToArithmetic = ptr[0] == 1;
            ptr = rs.getRecord(3);
            fontSize = ptr[0];
            ptr = rs.getRecord(4);
            repeatVibrate = Settings.bytesToInt(ptr);
            ptr = rs.getRecord(5);
            repeatSound = Settings.bytesToInt(ptr);
            ptr = rs.getRecord(6);
            repeatFlash = Settings.bytesToInt(ptr);
            ptr = rs.getRecord(7);
            displayStack = ptr[0] == 1;
            ptr = rs.getRecord(8);
            displayWelcome = ptr[0] == 1;
            ptr = rs.getRecord(9);
            NFSE = ptr[0];
            if (NFSE > 3) {
                NFSE = 1;
            }
            localNFSE = NFSE;
            ptr = rs.getRecord(10);
            fullscreen = ptr[0] == 1;
            ptr = rs.getRecord(11);
            safeStrings = ptr[0];
            ptr = rs.getRecord(12);
            useAlternativeLayout = ptr[0] == 1;
            rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RecordStore rsMem = RecordStore.openRecordStore((String)"Calc4M.1_mem", (boolean)true);
            if (rsMem.getNumRecords() != 4) {
                rsMem.closeRecordStore();
                RecordStore.deleteRecordStore((String)"Calc4M.1_mem");
                rsMem = RecordStore.openRecordStore((String)"Calc4M.1_mem", (boolean)true);
                for (i = 0; i < 4; ++i) {
                    m[i].toBytes(buf, 0);
                    rsMem.addRecord(buf, 0, 12);
                }
            }
            for (i = 0; i < 4; ++i) {
                ptr = rsMem.getRecord(i + 1);
                m[i].assign(ptr, 0);
            }
            rsMem.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
        hasRepeatEvent = this.hasRepeatEvents();
    }

    public static byte[] intToBytes(int value) {
        byte[] res = new byte[]{(byte)((value & 0xFF000000) >> 24), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        return res;
    }

    public static int bytesToInt(byte[] buf) {
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public static boolean getAutoReturnToArithmetic() {
        return autoReturnToArithmetic;
    }

    public static void setAutoReturnToArithmetic(boolean returnToArithmeticAutomatically) {
        autoReturnToArithmetic = returnToArithmeticAutomatically;
        Settings.setRMSEntry(STORE_NAME, 2, autoReturnToArithmetic);
    }

    public static void setDRG(byte newDRG) {
        DRG = newDRG;
        Settings.setRMSEntry(STORE_NAME, 1, DRG);
    }

    public static byte getDRG() {
        return DRG;
    }

    public static String getDRGString() {
        switch (DRG) {
            case 1: {
                return "Deg";
            }
            case 2: {
                return "Rad";
            }
            case 3: {
                return "Gra";
            }
        }
        return "?";
    }

    public static byte nextDRG() {
        if ((DRG = (byte)(DRG + 1)) > 3) {
            DRG = 1;
        }
        Settings.setRMSEntry(STORE_NAME, 1, DRG);
        return DRG;
    }

    public static byte getNFSE() {
        return NFSE;
    }

    public static void setNFSE(byte value) {
        localNFSE = NFSE = value;
        Settings.setRMSEntry(STORE_NAME, 9, NFSE);
        dashBoard.setNumberFormat(NFSE);
    }

    public static byte getLocalNFSE() {
        return localNFSE;
    }

    public static void setLocalNFSE(byte value) {
        localNFSE = value;
    }

    public static byte nextLocalFSE() {
        switch (localNFSE) {
            case 1: {
                localNFSE = (byte)2;
                break;
            }
            case 2: {
                localNFSE = (byte)3;
                break;
            }
            default: {
                localNFSE = 1;
            }
        }
        return localNFSE;
    }

    public static String getLocalNFSEString() {
        switch (localNFSE) {
            case 3: {
                return "Eng";
            }
            case 4: {
                return "Fix";
            }
            case 2: {
                return "Sci";
            }
        }
        if (localNFSE <= 0) {
            return "Fix" + -localNFSE;
        }
        return "";
    }

    public static byte getFontSize() {
        return fontSize;
    }

    public static void setFontSize(byte size) {
        fontSize = size;
        Settings.setRMSEntry(STORE_NAME, 3, fontSize);
    }

    public static Font getFont(int fontFace) {
        return Settings.getFont(fontSize, fontFace);
    }

    public static Font getFont(byte fontSize, int fontFace) {
        return Settings.getFont(fontSize, fontFace, 0);
    }

    public static Font getFont(byte fontSize, int fontFace, int fontStyle) {
        if (fontSize > 6) {
            fontSize = (byte)6;
        }
        if (fontSize < 1) {
            fontSize = 1;
        }
        switch (fontSize) {
            case 2: {
                return Font.getFont((int)fontFace, (int)(1 | fontStyle), (int)8);
            }
            case 3: {
                return Font.getFont((int)fontFace, (int)(0 | fontStyle), (int)0);
            }
            case 4: {
                return Font.getFont((int)fontFace, (int)(1 | fontStyle), (int)0);
            }
            case 5: {
                return Font.getFont((int)fontFace, (int)(0 | fontStyle), (int)16);
            }
            case 6: {
                return Font.getFont((int)fontFace, (int)(1 | fontStyle), (int)16);
            }
        }
        return Font.getFont((int)fontFace, (int)(0 | fontStyle), (int)8);
    }

    public static boolean getDoDisplayStack() {
        return displayStack;
    }

    public static void setDoDisplayStack(boolean doDisplay) {
        displayStack = doDisplay;
        Settings.setRMSEntry(STORE_NAME, 7, displayStack);
    }

    public static boolean getDoDisplayWelcome() {
        if (isFirstWelcome) {
            isFirstWelcome = false;
            return true;
        }
        return displayWelcome;
    }

    public static void setDoDisplayWelcome(boolean doDisplay) {
        displayWelcome = doDisplay;
        Settings.setRMSEntry(STORE_NAME, 8, displayWelcome);
    }

    public static boolean getFullScreen() {
        return fullscreen;
    }

    public static void setFullScreen(boolean full) {
        fullscreen = full;
        Settings.setRMSEntry(STORE_NAME, 10, fullscreen);
        dashBoard.setFullScreenMode(full);
    }

    public static byte getSafeStringsMode() {
        return safeStrings;
    }

    public static void setSafeStringsMode(byte safeStringMode) {
        safeStrings = safeStringMode;
        Settings.setRMSEntry(STORE_NAME, 11, safeStrings);
        dashBoard.repaint();
    }

    public static boolean getUseAlternativeLayout() {
        return useAlternativeLayout;
    }

    public static void setUseAlternativeLayout(boolean useAlternativeLayout) {
        Settings.useAlternativeLayout = useAlternativeLayout;
        Settings.setRMSEntry(STORE_NAME, 12, useAlternativeLayout);
        dashBoard.repaint();
    }

    public static void setCalcBase(int base) {
        CalcTextBox.setNumberBase(base);
    }

    public static int getCalcBase() {
        return CalcTextBox.getNumberBase();
    }

    public static String getCalcBaseString() {
        switch (CalcTextBox.getNumberBase()) {
            case 2: {
                return "Bin";
            }
            case 8: {
                return "Oct";
            }
            case 10: {
                return "";
            }
            case 16: {
                return "Hex";
            }
        }
        return "" + CalcTextBox.getNumberBase();
    }

    public static void setMarkVibration(boolean vibration) {
        repeatVibrate = vibration ? 50 : 0;
        Settings.setRMSEntry(STORE_NAME, 4, repeatVibrate);
    }

    public static boolean getMarkVibration() {
        return repeatVibrate > 0;
    }

    public static void setMarkSound(boolean sound) {
        repeatSound = sound ? 100 : 0;
        Settings.setRMSEntry(STORE_NAME, 5, repeatSound);
    }

    public static boolean getMarkSound() {
        return repeatSound > 0;
    }

    public static void setMarkFlash(boolean flash) {
        repeatFlash = flash ? 200 : 0;
        Settings.setRMSEntry(STORE_NAME, 6, repeatFlash);
    }

    public static boolean getMarkFlash() {
        return repeatFlash > 0;
    }

    public static Real getMemory(int memoryNum) {
        if (memoryNum < 1 || memoryNum > 4) {
            return null;
        }
        return m[memoryNum - 1];
    }

    public static void setMemory(int memoryNum, Real value) {
        if (memoryNum < 1 || memoryNum > 4) {
            return;
        }
        m[memoryNum - 1].assign(value);
        Settings.setRMSEntry("Calc4M.1_mem", memoryNum, m[memoryNum - 1]);
    }

    public static void addMemory(int memoryNum, Real value) {
        if (memoryNum < 1 || memoryNum > 4) {
            return;
        }
        m[memoryNum - 1].add(value);
        Settings.setRMSEntry("Calc4M.1_mem", memoryNum, m[memoryNum - 1]);
    }

    public static void clearMemory(int memoryNum) {
        if (memoryNum < 1 || memoryNum > 4) {
            return;
        }
        m[memoryNum - 1].assign(0);
        Settings.setRMSEntry("Calc4M.1_mem", memoryNum, m[memoryNum - 1]);
    }

    public static String getMemoryStringShort() {
        String ret = "";
        for (int i = 1; i <= 4; ++i) {
            ret = ret + "m" + i + ":";
            String tmpStr = Settings.getMemory(i).toString();
            if (tmpStr.length() > 5) {
                tmpStr = tmpStr.substring(0, 3) + "..";
            }
            ret = ret + tmpStr + " ";
        }
        return ret;
    }

    public static void markRepeat(Display display) {
        if (repeatVibrate > 0) {
            display.vibrate(repeatVibrate);
        }
        if (repeatSound > 0) {
            try {
                Manager.playTone((int)70, (int)repeatSound, (int)70);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (repeatFlash > 0) {
            display.flashBacklight(repeatFlash);
        }
    }

    public static boolean hasRepeat() {
        return hasRepeatEvent;
    }

    private static void setRMSEntry(String store, int pos, byte value) {
        byte[] buf = new byte[1];
        try {
            RecordStore rs = RecordStore.openRecordStore((String)store, (boolean)false);
            buf[0] = value;
            rs.setRecord(pos, buf, 0, 1);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void setRMSEntry(String store, int pos, int value) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)store, (boolean)false);
            rs.setRecord(pos, Settings.intToBytes(value), 0, 4);
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setRMSEntry(String store, int pos, Real value) {
        byte[] buf = new byte[12];
        try {
            RecordStore rs = RecordStore.openRecordStore((String)store, (boolean)false);
            value.toBytes(buf, 0);
            rs.setRecord(pos, buf, 0, 12);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void setRMSEntry(String store, int pos, boolean value) {
        byte[] buf = new byte[1];
        try {
            RecordStore rs = RecordStore.openRecordStore((String)store, (boolean)false);
            buf[0] = (byte)(value ? 1 : 0);
            rs.setRecord(pos, buf, 0, 1);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void show(Display display, DashBoard next) {
        String[] choiceStrs = new String[]{"Display welcome screen", "Display call stack", "Automatically return to arithmetic mode", "Full screen", "Use alternative button layout"};
        String[] safeStringStrs = new String[]{"Nice looking", "Special for Nokia", "Simple (only standard text)"};
        String[] numFormatStrs = new String[]{"Default 12345", "Sci 1.2345e4", "Eng 12.345e3", "Fixed (below) 12345.00"};
        String[] repeatStrs = new String[]{"Vibration", "Sound", "Flash backlight"};
        Settings.display = display;
        dashBoard = next;
        Form settingScreen = new Form("Settings");
        inpSettings = new ChoiceGroup("General", 2, choiceStrs, null);
        inpSettings.setSelectedIndex(0, Settings.getDoDisplayWelcome());
        inpSettings.setSelectedIndex(1, Settings.getDoDisplayStack());
        inpSettings.setSelectedIndex(2, Settings.getAutoReturnToArithmetic());
        inpSettings.setSelectedIndex(3, Settings.getFullScreen());
        inpSettings.setSelectedIndex(4, Settings.getUseAlternativeLayout());
        settingScreen.append((Item)inpSettings);
        inpSafeStrings = new ChoiceGroup("Button texts", 1, safeStringStrs, null);
        settingScreen.append((Item)inpSafeStrings);
        inpSafeStrings.setSelectedIndex(safeStrings == 1 ? 0 : (safeStrings == 2 ? 1 : 2), true);
        inpFontSizeGauge = new Gauge("Font size", true, 5, fontSize - 1);
        settingScreen.append((Item)inpFontSizeGauge);
        inpNumberFormat = new ChoiceGroup("Default number format", 1, numFormatStrs, null);
        settingScreen.append((Item)inpNumberFormat);
        if (NFSE > 0) {
            inpNumberFormat.setSelectedIndex(NFSE - 1, true);
        } else {
            inpNumberFormat.setSelectedIndex(3, true);
        }
        decimalCount = new TextField("Decimals (if fixed)", NFSE <= 0 ? "" + -NFSE : "", 2, 2);
        settingScreen.append((Item)decimalCount);
        inpRepeatMark = new ChoiceGroup("Button repeat notification", 2, repeatStrs, null);
        inpRepeatMark.setSelectedIndex(0, Settings.getMarkVibration());
        inpRepeatMark.setSelectedIndex(1, Settings.getMarkSound());
        inpRepeatMark.setSelectedIndex(2, Settings.getMarkFlash());
        settingScreen.append((Item)inpRepeatMark);
        commandOk = new Command("Ok", 4, 2);
        commandCancel = new Command("Cancel", 3, 3);
        settingScreen.addCommand(commandOk);
        settingScreen.addCommand(commandCancel);
        settingScreen.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)settingScreen);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == commandCancel) {
            display.setCurrent((Displayable)dashBoard);
        } else if (command == commandOk) {
            Settings.setFontSize((byte)inpFontSizeGauge.getValue());
            Settings.setDoDisplayWelcome(inpSettings.isSelected(0));
            Settings.setDoDisplayStack(inpSettings.isSelected(1));
            Settings.setAutoReturnToArithmetic(inpSettings.isSelected(2));
            Settings.setFullScreen(inpSettings.isSelected(3));
            dashBoard.setFullScreenMode(fullscreen);
            Settings.setUseAlternativeLayout(inpSettings.isSelected(4));
            dashBoard.setMode();
            Settings.setSafeStringsMode((byte)(inpSafeStrings.isSelected(0) ? 1 : (inpSafeStrings.isSelected(1) ? 2 : 0)));
            Settings.setFontSize((byte)(inpFontSizeGauge.getValue() + 1));
            dashBoard.updateCalcFont();
            try {
                Settings.setNFSE((byte)(inpNumberFormat.isSelected(0) ? 1 : (inpNumberFormat.isSelected(1) ? 2 : (inpNumberFormat.isSelected(2) ? 3 : -Math.abs(Byte.parseByte(decimalCount.getString()))))));
            }
            catch (Exception e) {
                Settings.setNFSE((byte)0);
            }
            dashBoard.setNumberFormat(NFSE);
            Settings.setMarkVibration(inpRepeatMark.isSelected(0));
            Settings.setMarkSound(inpRepeatMark.isSelected(1));
            Settings.setMarkFlash(inpRepeatMark.isSelected(2));
            dashBoard.sizeChanged(0, 0);
            display.setCurrent((Displayable)dashBoard);
        }
    }

    public void paint(Graphics g) {
    }

    static {
        localNFSE = NFSE = 1;
        fontSize = (byte)5;
        repeatVibrate = 50;
        repeatSound = 0;
        repeatFlash = 0;
        fullscreen = false;
        safeStrings = 1;
        useAlternativeLayout = true;
        isFirstWelcome = false;
    }
}

