/*
 * Decompiled with CFR 0.152.
 */
package Calc4M.midp1;

import Calc4M.midp1.Constants;
import Calc4M.midp1.DashBoard;
import Calc4M.midp1.Help;
import Calc4M.midp1.Settings;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Calc4M
extends MIDlet
implements CommandListener {
    public static final String APPLICATION_NAME = "Calc4M.m1";
    public static final String VERSION = "2.2";
    private Display display = null;
    private Settings settings = null;
    private boolean midletPaused = false;
    private DashBoard dashBoard = null;
    public Command commandCont = null;
    public Command commandHelpExit = null;
    public Command commandExit;
    public Command commandToArith;
    public Command commandNext;
    public Command commandSettings;
    public Command commandEquals;
    public Command commandConstants;
    public Command commandHelp;
    public Command commandClear;
    public Command commandUndo;

    public void startMIDlet() {
        RecordStore.listRecordStores();
        this.display = this.getDisplay();
        this.settings = new Settings();
        if (Settings.getDoDisplayWelcome()) {
            Form welcomeScreen = new Form("Calc4M.m1 2.2");
            StringItem text = new StringItem(null, null);
            text.setText("Thank you for using Calc4M.m1!\n\nPlease note that most buttons have two functions, press and hold to utilize the bottom right function.\n\nTo disable this start-up screen, go to settings and unselect the \"Display welcome screen\" option.\n\nMade by Lars Johanson, lars.johanson@mail.com\n\nUsing REAL library from http://real-java.sourceforge.net");
            welcomeScreen.append((Item)text);
            this.commandCont = new Command("Continue", 4, 1);
            welcomeScreen.addCommand(this.commandCont);
            welcomeScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)welcomeScreen);
        } else {
            this.displayDashboard();
        }
    }

    public void resumeMIDlet() {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.commandExit) {
            this.exitMIDlet();
        } else if (command == this.commandToArith) {
            this.dashBoard.setMode(1);
        } else if (command == this.commandNext) {
            this.dashBoard.nextMode();
        } else if (command == this.commandEquals) {
            this.dashBoard.equals();
        } else if (command == this.commandCont) {
            this.displayDashboard();
        } else if (command == this.commandHelpExit) {
            if (this.dashBoard != null) {
                this.display.setCurrent((Displayable)this.dashBoard);
            }
        } else if (command == this.commandHelp) {
            Help help = new Help();
            help.show(this.display, (Displayable)this.dashBoard);
        } else if (command == this.commandConstants) {
            Constants.show(this.display, this.dashBoard);
        } else if (command == this.commandSettings) {
            this.settings.show(this.display, this.dashBoard);
        } else if (command == this.commandClear) {
            if (this.dashBoard != null) {
                this.dashBoard.handleFunction(69);
            }
        } else if (command == this.commandUndo && this.dashBoard != null) {
            this.dashBoard.undo(false);
        }
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    private void displayDashboard() {
        this.commandEquals = new Command("=", 4, 2);
        this.commandToArith = new Command("Arithmetics [\u2193_]", 1, 3);
        this.commandNext = new Command("More functions [\u2193]", 1, 4);
        this.commandUndo = new Command("Undo [\u2190]", 1, 8);
        this.commandConstants = new Command("Constants", 1, 9);
        this.commandSettings = new Command("Settings", 1, 11);
        this.commandHelp = new Command("Help", 1, 15);
        this.commandExit = new Command("Exit", 1, 20);
        this.commandClear = new Command("Clear", 7, 1);
        this.dashBoard = new DashBoard(this, this.display, this.settings);
        this.dashBoard.setCommandListener(this);
        this.display.setCurrent((Displayable)this.dashBoard);
    }
}

